/*
 * Decompiled with CFR 0.152.
 */
package yt.jamesturner.DeathChest;

import java.util.List;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.type.EnderChest;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import yt.jamesturner.DeathChest.ChestData;
import yt.jamesturner.DeathChest.Main;

public class Chests {
    Main Plugin;

    public Chests(Main plugin) {
        this.Plugin = plugin;
    }

    public Boolean openChest(Player player, Block block) {
        if (this.Plugin.DeathChests.containsKey(this.locationToConfig(block.getLocation()))) {
            ChestData chest = this.Plugin.DeathChests.get(this.locationToConfig(block.getLocation()));
            if (((Boolean)this.Plugin.Config.settings.get("LockChests")).booleanValue() && !player.getUniqueId().toString().equals(chest.getUuid())) {
                this.Plugin.sendChatMessage(player, "This chest belongs to " + chest.getOwner());
                return true;
            }
            if (((Boolean)this.Plugin.Config.settings.get("PersistantChest")).booleanValue()) {
                if (this.Plugin.OpenedChests.containsKey(chest.getInventoryName())) {
                    this.Plugin.sendChatMessage(player, String.valueOf(this.Plugin.OpenedChests.get(chest.getInventoryName())) + " is currently using the chest!");
                    return true;
                }
                Inventory inv = Bukkit.createInventory((InventoryHolder)player, (int)45, (String)chest.getInventoryName());
                inv.setContents(chest.getInventory());
                player.openInventory(inv);
                this.Plugin.OpenedChests.put(chest.getInventoryName(), player.getName());
            } else {
                World w = chest.getLocation().getWorld();
                ItemStack[] itemStackArray = chest.getInventory();
                int n = itemStackArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ItemStack i = itemStackArray[n2];
                    if (i != null) {
                        w.dropItemNaturally(chest.getLocation(), i);
                    }
                    ++n2;
                }
                this.Plugin.Config.removeChest(chest);
            }
            return true;
        }
        return false;
    }

    public ChestData createNewChest(Player player, List<ItemStack> drops) {
        Block block = this.chooseFreeBlock(player.getLocation().getBlock());
        block.setType(Material.ENDER_CHEST);
        EnderChest enderChest = (EnderChest)block.getBlockData();
        BlockFace direction = enderChest.getFacing();
        String owner = player.getName();
        String uuid = player.getUniqueId().toString();
        Location location = block.getLocation();
        boolean hasSign = false;
        Location signLocation = null;
        Block s = block.getRelative(direction);
        if (this.isBlockFree(s)) {
            this.createSign(s, direction, owner);
            hasSign = true;
            signLocation = s.getLocation();
        }
        ChestData chest = this.createChestData(owner, uuid, location, drops, hasSign, signLocation);
        return chest;
    }

    public boolean recreateMissingChest(ChestData chest) {
        if (!chest.getLocation().getBlock().getType().equals((Object)Material.ENDER_CHEST)) {
            this.Plugin.sendConsoleMessage(ChatColor.RED + "Recreating missing chest: " + chest.getLocation().getBlockX() + "x " + chest.getLocation().getBlockY() + "y " + chest.getLocation().getBlockZ() + "z in " + chest.getLocation().getWorld().getName());
            chest.getLocation().getBlock().setType(Material.ENDER_CHEST);
            if (chest.hasSign()) {
                EnderChest enderChest = (EnderChest)chest.getLocation().getBlock().getBlockData();
                BlockFace direction = enderChest.getFacing();
                Block sign = chest.getLocation().getBlock().getRelative(direction);
                this.createSign(sign, direction, chest.getOwner());
            }
            return true;
        }
        return false;
    }

    public void createSign(Block s, BlockFace direction, String owner) {
        s.setType(Material.BIRCH_WALL_SIGN);
        Directional signData = (Directional)s.getBlockData();
        signData.setFacing(direction);
        s.setBlockData((BlockData)signData);
        Sign sign = (Sign)s.getState();
        sign.setLine(1, ChatColor.DARK_RED + "RIP");
        sign.setLine(2, ChatColor.DARK_RED + owner);
        sign.update();
    }

    public Block chooseFreeBlock(Block block) {
        if (!this.isBlockFree(block)) {
            Block nextBlock = block.getRelative(BlockFace.UP);
            while (!this.isBlockFree(nextBlock)) {
                nextBlock = nextBlock.getRelative(BlockFace.UP);
            }
            block = nextBlock;
        }
        return block;
    }

    public boolean isBlockFree(Block block) {
        if (block.isLiquid() && !block.getType().equals((Object)Material.WATER)) {
            return false;
        }
        return !block.getType().isSolid();
    }

    public ChestData createChestData(String owner, String uuid, Location location, List<ItemStack> items, boolean hasSign, Location signLocation) {
        ChestData chest = new ChestData();
        chest.setOwner(owner);
        chest.setUuid(uuid);
        chest.setLocation(location);
        chest.setHasSign(hasSign);
        if (hasSign) {
            chest.setSignLocation(signLocation);
        }
        chest.setInventoryName("Contents: " + chest.getLocation().getBlockX() + "x " + chest.getLocation().getBlockY() + "y " + chest.getLocation().getBlockZ() + "z");
        chest.setConfigKey(this.locationToConfig(chest.getLocation()));
        ItemStack[] drops = new ItemStack[items.size()];
        items.toArray(drops);
        chest.setInventory(drops);
        return chest;
    }

    public boolean inventoryIsEmpty(ItemStack[] items) {
        ItemStack[] itemStackArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack i = itemStackArray[n2];
            if (i != null) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public Block isSignAttachedToDeathChest(Block b) {
        Directional directional;
        Block blockBehind;
        BlockData data;
        if (b != null && b.getState() instanceof Sign && (data = b.getBlockData()) instanceof Directional && this.Plugin.DeathChests.containsKey(this.locationToConfig((blockBehind = b.getRelative((directional = (Directional)data).getFacing().getOppositeFace())).getLocation()))) {
            return blockBehind;
        }
        return null;
    }

    public String locationToConfig(Location location) {
        return String.valueOf(location.getBlockX()) + "x" + location.getBlockY() + "y" + location.getBlockZ() + "z";
    }
}

