/*
 * Decompiled with CFR 0.152.
 */
package yt.jamesturner.DeathChest;

import java.util.HashMap;
import java.util.List;
import net.md_5.bungee.api.ChatColor;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import yt.jamesturner.DeathChest.ChestData;
import yt.jamesturner.DeathChest.Chests;
import yt.jamesturner.DeathChest.Commands;
import yt.jamesturner.DeathChest.ConfigFiles.Config;
import yt.jamesturner.DeathChest.Listeners;
import yt.jamesturner.DeathChest.VersionCheck;

public class Main
extends JavaPlugin {
    public Config Config;
    public Chests Chests;
    public HashMap<String, ChestData> DeathChests = new HashMap();
    public HashMap<String, String> OpenedChests = new HashMap();
    public String newUpdate = "";

    public void onEnable() {
        this.Config = new Config(this);
        this.Chests = new Chests(this);
        this.saveDefaultConfig();
        this.Config.loadSettings();
        this.Config.loadChests();
        this.getServer().getPluginManager().registerEvents((Listener)new Listeners(this), (Plugin)this);
        this.getCommand("dchest").setExecutor((CommandExecutor)new Commands(this));
        if (this.Config.settings.containsKey("VersionCheck") && ((Boolean)this.Config.settings.get("VersionCheck")).booleanValue()) {
            VersionCheck versionCheck = new VersionCheck(this, (CommandSender)this.getServer().getConsoleSender(), true);
            versionCheck.runTaskLaterAsynchronously((Plugin)this, 20L);
        }
    }

    public void onDisable() {
        this.Config.saveChests();
    }

    public void sendChatMessage(Player player, String message) {
        player.sendMessage(ChatColor.YELLOW + "[" + this.getDescription().getName() + "] " + ChatColor.RESET + message);
    }

    public void sendChatMessage(Player player, List<String> message) {
        player.sendMessage(ChatColor.YELLOW + "[" + this.getDescription().getName() + "]");
        for (String s : message) {
            player.sendMessage(s);
        }
    }

    public void sendConsoleMessage(String message) {
        Bukkit.getConsoleSender().sendMessage(ChatColor.YELLOW + "[" + this.getDescription().getName() + "]" + ChatColor.DARK_GRAY + "[" + this.getDescription().getVersion() + "] " + ChatColor.RESET + message);
    }

    public void sendConsoleMessage(String message, ChatColor color) {
        Bukkit.getConsoleSender().sendMessage(ChatColor.YELLOW + "[" + this.getDescription().getName() + "]" + ChatColor.DARK_GRAY + "[" + this.getDescription().getVersion() + "] " + ChatColor.RESET + color + message);
    }

    public void sendConsoleMessage(List<String> messages) {
        String prefix = ChatColor.YELLOW + "[" + this.getDescription().getName() + "]" + ChatColor.DARK_GRAY + "[" + this.getDescription().getVersion() + "] " + ChatColor.RESET;
        int prefix_length = this.getDescription().getName().length() + this.getDescription().getVersion().length() + 5;
        Bukkit.getConsoleSender().sendMessage(String.valueOf(prefix) + messages.get(0));
        int i = 1;
        while (i < messages.size()) {
            String msg = String.format("%" + (prefix_length + messages.get(i).length()) + "s", messages.get(i));
            Bukkit.getConsoleSender().sendMessage(msg);
            ++i;
        }
    }

    public void sendConsoleMessage(List<String> messages, ChatColor color) {
        String prefix = ChatColor.YELLOW + "[" + this.getDescription().getName() + "]" + ChatColor.DARK_GRAY + "[" + this.getDescription().getVersion() + "] " + ChatColor.RESET;
        int prefix_length = this.getDescription().getName().length() + this.getDescription().getVersion().length() + 5;
        Bukkit.getConsoleSender().sendMessage(String.valueOf(prefix) + color + messages.get(0));
        int i = 1;
        while (i < messages.size()) {
            String msg = color + String.format("%" + (prefix_length + messages.get(i).length()) + "s", messages.get(i));
            Bukkit.getConsoleSender().sendMessage(msg);
            ++i;
        }
    }

    public String chestLocationMessage(ChestData chest) {
        return ChatColor.RESET + " \u25ba " + ChatColor.YELLOW + "(" + chest.getLocation().getBlockX() + ", " + chest.getLocation().getBlockY() + ", " + chest.getLocation().getBlockZ() + ")" + ChatColor.RESET + " in " + ChatColor.YELLOW + StringUtils.capitalize((String)chest.getLocation().getWorld().getName());
    }
}

