/*
 * Decompiled with CFR 0.152.
 */
package yt.jamesturner.DeathChest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import yt.jamesturner.DeathChest.ChestData;
import yt.jamesturner.DeathChest.ConfigFiles.Config;
import yt.jamesturner.DeathChest.Main;
import yt.jamesturner.DeathChest.utils.VersionCheck;

public class Commands
implements CommandExecutor {
    Main Plugin;
    Config Config;

    public Commands(Main plugin) {
        this.Plugin = plugin;
        this.Config = plugin.Config;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        block28: {
            block25: {
                block26: {
                    if (args.length == 0) {
                        return this.help(sender, label);
                    }
                    if (!sender.hasPermission("deathchest.op")) break block25;
                    if (args.length != 1) break block26;
                    switch (args[0].toLowerCase()) {
                        case "reload": {
                            return this.reloadConfig(sender);
                        }
                        case "fix": {
                            return this.fixChests(sender);
                        }
                        case "version": {
                            return this.version(sender);
                        }
                        case "set": {
                            return this.setList(args, sender);
                        }
                    }
                    break block25;
                }
                if (args.length == 3 && args[0].equalsIgnoreCase("set")) {
                    return this.changeBooleanSetting(args, sender);
                }
            }
            if (args.length != 1) break block28;
            switch (args[0].toLowerCase()) {
                case "list": {
                    return this.listChests(sender);
                }
            }
            return this.help(sender, label);
        }
        return this.help(sender, label);
    }

    private boolean help(CommandSender sender, String label) {
        HashMap<String, String> commands = new HashMap<String, String>();
        commands.put("list", "List all of your DeathChest locations");
        if (sender.hasPermission("deathchest.op")) {
            commands.put("fix", "Fixes and missing chests that have been destroyed");
            commands.put("reload", "Reloads configuration settings from config.yml");
            commands.put("version", "Check whether you have the latest version or not");
            commands.put("set <setting> [true/false]", "Change a config.yml setting");
        }
        sender.sendMessage("--------" + ChatColor.YELLOW + " [" + this.Plugin.getDescription().getName() + "]" + ChatColor.RESET + " Help --------");
        for (Map.Entry entry : commands.entrySet()) {
            String message = ChatColor.GREEN + "/" + label + " " + (String)entry.getKey() + " " + ChatColor.RESET + (String)entry.getValue();
            sender.sendMessage(message);
        }
        return true;
    }

    private boolean setList(String[] args, CommandSender sender) {
        ArrayList<String> settings = new ArrayList<String>();
        for (String setting : this.Plugin.Config.booleanSettings) {
            settings.add(setting);
        }
        this.Plugin.Messages.send(sender, "You can change these settings: " + String.join((CharSequence)", ", settings));
        return true;
    }

    private boolean changeBooleanSetting(String[] args, CommandSender sender) {
        if (args[2].equalsIgnoreCase("true") || args[2].equalsIgnoreCase("false")) {
            for (String setting : this.Plugin.Config.booleanSettings) {
                if (!args[1].equalsIgnoreCase(setting)) continue;
                this.Plugin.Config.settings.put(setting, Boolean.valueOf(args[2]));
                this.Plugin.Config.saveSettings();
                this.Plugin.Config.saveConfig();
                String bool = args[2].toLowerCase();
                bool = bool.equalsIgnoreCase("false") ? ChatColor.RED + bool : ChatColor.AQUA + bool;
                String msg = ChatColor.GREEN + setting + ChatColor.RESET + " set to " + bool;
                this.Plugin.Messages.send(sender, msg);
                return true;
            }
            String msg = String.valueOf(args[1]) + " is not a valid setting, try " + String.join((CharSequence)", ", this.Plugin.Config.booleanSettings);
            this.Plugin.Messages.send(sender, msg);
            return true;
        }
        String msg = "Value must be either " + ChatColor.AQUA + "true" + ChatColor.RESET + " or " + ChatColor.RED + "false";
        this.Plugin.Messages.send(sender, msg);
        return true;
    }

    private boolean reloadConfig(CommandSender sender) {
        this.Plugin.reloadConfig();
        this.Config.loadSettings();
        this.Plugin.Messages.send(sender, "Settings reloaded!");
        return true;
    }

    private boolean version(CommandSender sender) {
        if (this.Plugin.versionTask != null) {
            Bukkit.getScheduler().cancelTask(this.Plugin.versionTask.getTaskId());
        }
        this.Plugin.versionCheck = new VersionCheck(this.Plugin, sender, true);
        this.Plugin.versionTask = this.Plugin.versionCheck.runTaskAsynchronously((Plugin)this.Plugin);
        return true;
    }

    private boolean fixChests(CommandSender sender) {
        int count = 0;
        for (Map.Entry<String, ChestData> entry : this.Plugin.DeathChests.entrySet()) {
            if (!this.Plugin.Chests.recreateMissingChest(entry.getValue())) continue;
            ++count;
        }
        if (count == 0) {
            this.Plugin.Messages.send(sender, "No missing chests found!");
        } else {
            this.Plugin.Messages.send(sender, String.valueOf(count) + " missing chests were fixed and replaced!");
        }
        return true;
    }

    private boolean listChests(CommandSender sender) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            ArrayList<ChestData> playersDeathChests = new ArrayList<ChestData>();
            for (Map.Entry<String, ChestData> entry : this.Plugin.DeathChests.entrySet()) {
                if (!entry.getValue().getUuid().equalsIgnoreCase(player.getUniqueId().toString())) continue;
                playersDeathChests.add(entry.getValue());
            }
            if (playersDeathChests.size() < 1) {
                this.Plugin.Messages.send(sender, "You don't have any DeathChests left around");
                return true;
            }
            ArrayList<TextComponent> locations = new ArrayList<TextComponent>();
            locations.add(new TextComponent("Your DeathChests are located at:"));
            for (ChestData chest : playersDeathChests) {
                locations.add(this.Plugin.Chests.chestLocationMessage(player, chest));
            }
            this.Plugin.Messages.send((CommandSender)player, locations, true, false, true);
            return true;
        }
        this.Plugin.Messages.send("Must be a player in game");
        return true;
    }
}

