/*
 * Decompiled with CFR 0.152.
 */
package yt.jamesturner.DeathChest;

import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;
import yt.jamesturner.DeathChest.ChestData;
import yt.jamesturner.DeathChest.Chests;
import yt.jamesturner.DeathChest.Commands;
import yt.jamesturner.DeathChest.ConfigFiles.Config;
import yt.jamesturner.DeathChest.Listeners;
import yt.jamesturner.DeathChest.utils.Messages;
import yt.jamesturner.DeathChest.utils.VersionCheck;

public class Main
extends JavaPlugin {
    public Config Config;
    public Chests Chests;
    public Messages Messages;
    public VersionCheck versionCheck;
    public HashMap<String, ChestData> DeathChests = new HashMap();
    public HashMap<String, String> OpenedChests = new HashMap();
    public String newUpdate = "";
    public BukkitTask versionTask;
    private static final String[] CARDINAL = new String[]{"North", "Northwest", "West", "Southwest", "South", "Southeast", "East", "Northeast"};
    private static final String[] CARDINAL_ABV = new String[]{"N", "NW", "W", "SW", "S", "SE", "E", "NE"};

    public void onEnable() {
        this.Messages = new Messages(this);
        this.Config = new Config(this);
        this.Chests = new Chests(this);
        this.saveDefaultConfig();
        this.Config.loadSettings();
        this.Config.loadChests();
        this.getServer().getPluginManager().registerEvents((Listener)new Listeners(this), (Plugin)this);
        this.getCommand("dchest").setExecutor((CommandExecutor)new Commands(this));
        Plugin navigationBar = this.getServer().getPluginManager().getPlugin("NavigationBar");
        if (navigationBar != null && ((String)navigationBar.getDescription().getAuthors().get(0)).equalsIgnoreCase("JamesTurner")) {
            this.Messages.send("NavigationBar found. Enabling navigation to DeathChests.", true);
            this.Config.settings.put("NavigationBarIntegration", true);
        }
        if (this.Config.settings.containsKey("VersionCheck") && ((Boolean)this.Config.settings.get("VersionCheck")).booleanValue()) {
            this.versionCheck = new VersionCheck(this, (CommandSender)this.getServer().getConsoleSender(), true);
            this.versionTask = this.versionCheck.runTaskLaterAsynchronously((Plugin)this, 20L);
        }
    }

    public void onDisable() {
        this.Config.saveChests();
        if (this.versionTask != null) {
            Bukkit.getScheduler().cancelTask(this.versionTask.getTaskId());
        }
    }

    public String getDirection(Location source, Location destination, boolean abbreviate) {
        int compass = ((int)Math.round(Math.atan2(source.getX() - destination.getX(), source.getZ() - destination.getZ()) / 0.7853981633974483) + 8) % 8;
        if (abbreviate) {
            return CARDINAL_ABV[compass];
        }
        return CARDINAL[compass];
    }
}

