/*
 * Decompiled with CFR 0.152.
 */
package yt.jamesturner.DeathChest;

import java.util.HashMap;
import java.util.Map;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import yt.jamesturner.DeathChest.ChestData;
import yt.jamesturner.DeathChest.ConfigFiles.Config;
import yt.jamesturner.DeathChest.Main;

public class Commands
implements CommandExecutor {
    Main Plugin;
    Config Config;

    public Commands(Main plugin) {
        this.Plugin = plugin;
        this.Config = plugin.Config;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        block11: {
            if (args.length == 0) {
                return this.help(sender, label);
            }
            if (args.length != 1) break block11;
            switch (args[0].toLowerCase()) {
                case "reload": {
                    return this.reloadConfig(sender);
                }
                case "fix": {
                    return this.fixChests(sender);
                }
            }
            return this.help(sender, label);
        }
        return this.help(sender, label);
    }

    private boolean help(CommandSender sender, String label) {
        HashMap<String, String> commands = new HashMap<String, String>();
        commands.put("fix", "Fixes and missing chests that have been destroyed");
        commands.put("reload", "Reloads configuration settings from config.yml");
        sender.sendMessage("--------" + ChatColor.YELLOW + " [" + this.Plugin.getDescription().getName() + "]" + ChatColor.RESET + " Help --------");
        for (Map.Entry entry : commands.entrySet()) {
            String message = ChatColor.GREEN + "/" + label + " " + (String)entry.getKey() + " " + ChatColor.RESET + (String)entry.getValue();
            sender.sendMessage(message);
        }
        return true;
    }

    private boolean reloadConfig(CommandSender sender) {
        this.Plugin.reloadConfig();
        this.Config.loadSettings();
        this.Plugin.sendConsoleMessage("Settings reloaded!");
        if (sender instanceof Player) {
            this.Plugin.sendChatMessage((Player)sender, "Settings reloaded!");
        }
        return true;
    }

    private boolean fixChests(CommandSender sender) {
        int count = 0;
        for (Map.Entry<String, ChestData> entry : this.Plugin.DeathChests.entrySet()) {
            if (!this.Plugin.Chests.recreateMissingChest(entry.getValue())) continue;
            ++count;
        }
        if (count == 0) {
            if (sender instanceof Player) {
                this.Plugin.sendChatMessage((Player)sender, "No missing chests found!");
            } else {
                this.Plugin.sendConsoleMessage("No missing chests found!");
            }
        } else if (sender instanceof Player) {
            this.Plugin.sendChatMessage((Player)sender, String.valueOf(count) + " missing chests were fixed and replaced!");
        } else {
            this.Plugin.sendConsoleMessage(String.valueOf(count) + " missing chests were fixed and replaced!");
        }
        return true;
    }
}

