/*
 * Decompiled with CFR 0.152.
 */
package yt.jamesturner.DeathChest.ConfigFiles;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.type.EnderChest;
import org.bukkit.configuration.file.FileConfiguration;
import yt.jamesturner.DeathChest.ChestData;
import yt.jamesturner.DeathChest.Chests;
import yt.jamesturner.DeathChest.ConfigFiles.ChestsYML;
import yt.jamesturner.DeathChest.Main;

public class Config {
    Main Plugin;
    Chests Chests;
    public ChestsYML ChestsYML;
    public HashMap<String, Object> settings = new HashMap();
    private List<String> booleanSettings = new ArrayList<String>();

    public Config(Main plugin) {
        this.Plugin = plugin;
        this.ChestsYML = new ChestsYML(plugin);
        this.booleanSettings.add("PersistantChest");
        this.booleanSettings.add("ChestInLava");
        this.booleanSettings.add("LockChests");
    }

    public void loadSettings() {
        if (this.Chests == null) {
            this.Chests = this.Plugin.Chests;
        }
        for (String setting : this.booleanSettings) {
            if (this.configExists("Settings." + setting, this.Plugin.getConfig()) && this.Plugin.getConfig().isBoolean("Settings." + setting)) {
                this.settings.put(setting, this.Plugin.getConfig().getBoolean("Settings." + setting));
                continue;
            }
            this.Plugin.getConfig().set("Settings." + setting, (Object)false);
            this.Plugin.saveConfig();
            this.settings.put(setting, false);
        }
        this.sendSettingsMessage();
    }

    public void loadChests() {
        if (!this.Plugin.DeathChests.isEmpty()) {
            this.Plugin.DeathChests.clear();
        }
        if (!this.ChestsYML.getConfig().isConfigurationSection("Chest")) {
            return;
        }
        for (String key : this.ChestsYML.getConfig().getConfigurationSection("Chest").getKeys(false)) {
            String owner = this.ChestsYML.getConfig().getString("Chest." + key + ".owner");
            String uuid = this.ChestsYML.getConfig().getString("Chest." + key + ".uuid");
            Location location = this.ChestsYML.getConfig().getLocation("Chest." + key + ".location");
            boolean hasSign = false;
            if (this.ChestsYML.getConfig().isSet("Chest." + key + ".sign.hasSign")) {
                hasSign = this.ChestsYML.getConfig().getBoolean("Chest." + key + ".sign.hasSign");
            }
            Location signLocation = null;
            if (this.ChestsYML.getConfig().isSet("Chest." + key + ".sign.location")) {
                signLocation = this.ChestsYML.getConfig().getLocation("Chest." + key + ".sign.location");
            }
            List items = (List)this.ChestsYML.getConfig().get("Chest." + key + ".inventory");
            ChestData chest = this.Chests.createChestData(owner, uuid, location, items, hasSign, signLocation);
            this.Chests.recreateMissingChest(chest);
            this.Plugin.DeathChests.put(chest.getConfigKey(), chest);
        }
    }

    public void removeChest(ChestData chest) {
        if (this.Plugin.DeathChests.containsKey(chest.getConfigKey())) {
            this.Plugin.DeathChests.remove(chest.getConfigKey());
        }
        if (this.configExists("Chest." + chest.getConfigKey(), this.ChestsYML.getConfig())) {
            this.ChestsYML.getConfig().set("Chest." + chest.getConfigKey(), null);
            this.ChestsYML.save();
            this.ChestsYML.load();
        }
        if (chest.getLocation().getBlock().getType().equals((Object)Material.ENDER_CHEST)) {
            EnderChest enderChest = (EnderChest)chest.getLocation().getBlock().getBlockData();
            BlockFace direction = enderChest.getFacing();
            Block s = chest.getLocation().getBlock().getRelative(direction);
            if (s.getType().equals((Object)Material.BIRCH_WALL_SIGN)) {
                s.setType(Material.AIR);
            }
        }
        chest.getLocation().getBlock().setType(Material.AIR);
    }

    public void saveSettings() {
        for (String setting : this.booleanSettings) {
            if (this.settings.containsKey(setting)) {
                this.Plugin.getConfig().set("Settings." + setting, this.settings.get(setting));
                continue;
            }
            this.Plugin.getConfig().set("Settings." + setting, (Object)false);
        }
    }

    public void saveChests() {
        if (this.Plugin.DeathChests.isEmpty()) {
            return;
        }
        for (Map.Entry<String, ChestData> entry : this.Plugin.DeathChests.entrySet()) {
            this.saveChestToConfig(entry.getValue());
        }
        this.ChestsYML.save();
    }

    public void saveChestToConfig(ChestData chest) {
        String config = "Chest." + chest.getConfigKey();
        this.ChestsYML.getConfig().set(String.valueOf(config) + ".owner", (Object)chest.getOwner());
        this.ChestsYML.getConfig().set(String.valueOf(config) + ".uuid", (Object)chest.getUuid());
        this.ChestsYML.getConfig().set(String.valueOf(config) + ".location", (Object)chest.getLocation());
        this.ChestsYML.getConfig().set(String.valueOf(config) + ".sign.hasSign", (Object)chest.hasSign());
        this.ChestsYML.getConfig().set(String.valueOf(config) + ".sign.location", (Object)chest.getSignLocation());
        this.ChestsYML.getConfig().set(String.valueOf(config) + ".inventory", (Object)chest.getInventory());
    }

    private boolean configExists(String location, FileConfiguration config) {
        return config.isSet(location);
    }

    private void sendSettingsMessage() {
        Bukkit.getConsoleSender().sendMessage("-------- " + ChatColor.YELLOW + "[" + this.Plugin.getDescription().getName() + "]" + ChatColor.DARK_GRAY + "[" + this.Plugin.getDescription().getVersion() + "] " + ChatColor.RESET + "Settings --------");
        for (Map.Entry<String, Object> entry : this.settings.entrySet()) {
            Object value = entry.getValue();
            String message = String.valueOf(entry.getKey()) + ": ";
            if (value instanceof Boolean) {
                message = String.valueOf(message) + String.valueOf(value);
            }
            Bukkit.getConsoleSender().sendMessage(message);
        }
    }
}

