/*
 * Decompiled with CFR 0.152.
 */
package yt.jamesturner.navigation.commands.SubCommands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import yt.jamesturner.navigation.commands.CommandFunctions;
import yt.jamesturner.navigation.data.type.SavedLocation;
import yt.jamesturner.navigation.data.type.SubCommand;

public class GlobalCommand
extends SubCommand {
    public GlobalCommand(CommandFunctions cf) {
        super(cf);
    }

    @Override
    public String getName() {
        return "global";
    }

    @Override
    public String getDescription() {
        return "Modify global locations";
    }

    @Override
    public String getSyntax() {
        return "/poi global <add | remove>";
    }

    @Override
    public int getMaxNumberOfArgs() {
        return -1;
    }

    @Override
    public String getPermission() {
        return this.plugin.Config.getPermissionNode() + "commands.global";
    }

    @Override
    public String getPermissionDefault() {
        return "op";
    }

    @Override
    public boolean canPlayerRun() {
        return true;
    }

    @Override
    public boolean canConsoleRun() {
        return false;
    }

    @Override
    public void run(CommandSender sender, String[] args) {
        if (!this.cf.canRunCommand(this, sender)) {
            return;
        }
        Player player = (Player)sender;
        if (args.length > 2) {
            String displayName = String.join((CharSequence)" ", Arrays.copyOfRange(args, 2, args.length));
            switch (args[1].toLowerCase()) {
                case "add": {
                    SavedLocation s = new SavedLocation(this.plugin, player.getLocation(), displayName);
                    if (this.plugin.LocationsList.getGlobalLocations().addSavedLocation(s, sender)) {
                        this.plugin.Messages.send(sender, this.plugin.Messages.highlight("{0} was saved at \u25ba ({1}, {2}, {3}) in {4}", s.getDisplayName(), String.valueOf(s.getLocation().getBlockX()), String.valueOf(s.getLocation().getBlockY()), String.valueOf(s.getLocation().getBlockZ()), s.getLocation().getWorld().getName()));
                    }
                    return;
                }
                case "remove": {
                    String commandName = this.plugin.normalizeTextInput(displayName);
                    this.plugin.LocationsList.getGlobalLocations().removeSavedLocation(commandName, sender);
                    return;
                }
            }
            this.cf.getCommandHelp(sender, this);
            return;
        }
        this.cf.getCommandHelp(sender, this);
    }

    @Override
    public List<String> getArguments(CommandSender sender, String[] args) {
        return null;
    }

    @Override
    public SubCommand getSubCommand(String name) {
        return null;
    }

    @Override
    public List<String> getSubCommands(CommandSender sender, String[] args) {
        if (args.length == 2) {
            return Arrays.asList("add", "remove");
        }
        if (args.length == 3 && args[1].equalsIgnoreCase("remove")) {
            ArrayList<String> locations = new ArrayList<String>();
            if (sender instanceof Player) {
                for (SavedLocation s : this.plugin.LocationsList.getGlobalLocations().getAllLocations("*")) {
                    locations.add(s.getDisplayName());
                }
            }
            return locations;
        }
        return null;
    }
}

