/*
 * Decompiled with CFR 0.152.
 */
package yt.jamesturner.navigation.commands.SubCommands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import yt.jamesturner.navigation.commands.CommandFunctions;
import yt.jamesturner.navigation.data.type.SavedLocation;
import yt.jamesturner.navigation.data.type.SubCommand;

public class GotoCommand
extends SubCommand {
    public GotoCommand(CommandFunctions cf) {
        super(cf);
    }

    @Override
    public String getName() {
        return "goto";
    }

    @Override
    public String getDescription() {
        return "Navigate to a saved location";
    }

    @Override
    public String getSyntax() {
        return "/poi goto <Location Name>";
    }

    @Override
    public int getMaxNumberOfArgs() {
        return -1;
    }

    @Override
    public String getPermission() {
        return String.valueOf(this.plugin.Config.getPermissionNode()) + "commands.goto";
    }

    @Override
    public String getPermissionDefault() {
        return "true";
    }

    @Override
    public boolean canPlayerRun() {
        return true;
    }

    @Override
    public boolean canConsoleRun() {
        return false;
    }

    @Override
    public void run(CommandSender sender, String[] args) {
        if (!this.cf.canRunCommand(this, sender)) {
            return;
        }
        if (args.length < 2) {
            this.cf.getCommandHelp(sender, this);
            return;
        }
        Player player = (Player)sender;
        String displayName = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
        String commandName = this.plugin.normalizeTextInput(displayName);
        SavedLocation s = this.plugin.LocationsList.getPlayerLocations(player).contains(commandName);
        if (s == null) {
            s = this.plugin.LocationsList.getGlobalLocations().contains(commandName);
        }
        if (s == null) {
            this.plugin.Messages.send(sender, "No location named {0} exists.", true, true, displayName);
            return;
        }
        if (!s.getLocation().getWorld().getName().equalsIgnoreCase(player.getLocation().getWorld().getName())) {
            this.plugin.Messages.send(sender, "{0} is in another world. Travel to {1} first to begin navigation.", true, true, displayName, s.getLocation().getWorld().getName());
            return;
        }
        this.plugin.clearPlayerNavigation(player);
        this.plugin.addPlayerNavigation(player, s);
    }

    @Override
    public List<String> getArguments(CommandSender sender, String[] args) {
        return null;
    }

    @Override
    public SubCommand getSubCommand(String name) {
        return null;
    }

    @Override
    public List<String> getSubCommands(CommandSender sender, String[] args) {
        ArrayList<String> locations = new ArrayList<String>();
        if (args.length != 2) {
            return locations;
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            ArrayList<Object> tmplist = new ArrayList();
            tmplist = this.plugin.LocationsList.getGlobalLocations().getAllLocations(player.getLocation().getWorld().getName());
            if (tmplist != null) {
                for (SavedLocation savedLocation : tmplist) {
                    locations.add(savedLocation.getDisplayName());
                }
                tmplist.clear();
            }
            if ((tmplist = this.plugin.LocationsList.getPlayerLocations(player).getAllLocations(player.getLocation().getWorld().getName())) != null) {
                for (SavedLocation savedLocation : tmplist) {
                    locations.add(savedLocation.getDisplayName());
                }
                tmplist.clear();
            }
        }
        return locations;
    }
}

