/*
 * Decompiled with CFR 0.152.
 */
package yt.jamesturner.navigation.commands.SubCommands;

import java.util.ArrayList;
import java.util.List;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import yt.jamesturner.navigation.commands.CommandFunctions;
import yt.jamesturner.navigation.data.type.SavedLocation;
import yt.jamesturner.navigation.data.type.SubCommand;

public class MyListCommand
extends SubCommand {
    public MyListCommand(CommandFunctions cf) {
        super(cf);
    }

    @Override
    public String getName() {
        return "mylist";
    }

    @Override
    public String getDescription() {
        return "List your saved locations";
    }

    @Override
    public String getSyntax() {
        return "/poi mylist";
    }

    @Override
    public int getMaxNumberOfArgs() {
        return 2;
    }

    @Override
    public String getPermission() {
        return this.plugin.Config.getPermissionNode() + "commands.mylist";
    }

    @Override
    public String getPermissionDefault() {
        return "true";
    }

    @Override
    public boolean canPlayerRun() {
        return true;
    }

    @Override
    public boolean canConsoleRun() {
        return false;
    }

    @Override
    public void run(CommandSender sender, String[] args) {
        if (!this.cf.canRunCommand(this, sender)) {
            return;
        }
        Player player = (Player)sender;
        if (this.plugin.LocationsList.getPlayerLocations(player).size() < 1) {
            this.plugin.Messages.send((CommandSender)player, "You don't have any {0}. Try using {1}", true, false, "saved locations", "/poi save <Name of Location>");
            return;
        }
        ArrayList<TextComponent> locations = new ArrayList<TextComponent>();
        locations.add(new TextComponent("Your saved locations are"));
        boolean alternateHighlight = false;
        String world = player.getLocation().getWorld().getName();
        int page = 1;
        if (args.length == 2 && this.plugin.isInteger(args[1])) {
            page = Integer.parseInt(args[1]);
        }
        for (SavedLocation s : this.plugin.LocationsList.getPlayerLocations(player).getPaginatedLocations(page, world)) {
            locations.add(this.plugin.LocationsList.listLocations(sender, s, alternateHighlight));
            if (alternateHighlight) {
                alternateHighlight = false;
                continue;
            }
            alternateHighlight = true;
        }
        TextComponent pageButtons = this.plugin.LocationsList.getPlayerLocations(player).getPageButtons(page, world, true);
        if (pageButtons != null) {
            locations.add(pageButtons);
        }
        this.plugin.Messages.send((CommandSender)player, locations, true, false, true);
    }

    @Override
    public List<String> getArguments(CommandSender sender, String[] args) {
        return null;
    }

    @Override
    public SubCommand getSubCommand(String name) {
        return null;
    }

    @Override
    public List<String> getSubCommands(CommandSender sender, String[] args) {
        ArrayList<String> pages = new ArrayList<String>();
        if (args.length != 2) {
            return pages;
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            for (int i = 1; i <= this.plugin.LocationsList.getPlayerLocations(player).getNumberOfPages(player.getLocation().getWorld().getName()); ++i) {
                pages.add(String.valueOf(i));
            }
        }
        return pages;
    }
}

