/*
 * Decompiled with CFR 0.152.
 */
package yt.jamesturner.navigation.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import yt.jamesturner.navigation.Main;
import yt.jamesturner.navigation.data.type.SubCommand;

public class CommandFunctions {
    Main plugin;

    public CommandFunctions(Main plugin) {
        this.plugin = plugin;
    }

    public Main getPlugin() {
        return this.plugin;
    }

    public boolean canRunCommand(SubCommand command, CommandSender sender) {
        return this.canRunCommandFunction(command, sender, true);
    }

    public boolean canRunCommand(SubCommand command, CommandSender sender, boolean sendSenderMessages) {
        return this.canRunCommandFunction(command, sender, sendSenderMessages);
    }

    private boolean canRunCommandFunction(SubCommand command, CommandSender sender, boolean sendSenderMessages) {
        String result = "";
        if (sender instanceof Player) {
            if (!command.canPlayerRun()) {
                result = "You can not run this command";
            } else if (!((Player)sender).hasPermission(command.getPermission())) {
                result = "You do not have permission to run this command";
            }
        } else if (!command.canConsoleRun()) {
            result = "Only players can run this command";
        }
        if (result.length() > 0) {
            if (sendSenderMessages) {
                this.plugin.Messages.send(sender, result);
            }
            return false;
        }
        return true;
    }

    public void getCommandHelp(CommandSender sender, List<SubCommand> subCommands) {
        this.printCommandHelp(sender, subCommands);
    }

    public void getCommandHelp(CommandSender sender, SubCommand subCommand) {
        this.printCommandHelp(sender, new ArrayList<SubCommand>(Arrays.asList(subCommand)));
    }

    private void printCommandHelp(CommandSender sender, List<SubCommand> subCommands) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("Command Usage");
        for (SubCommand sc : subCommands) {
            if (!this.canRunCommand(sc, sender, false)) continue;
            lines.add(ChatColor.GOLD + sc.getSyntax() + ChatColor.RESET + " - " + ChatColor.GRAY + sc.getDescription());
        }
        this.plugin.Messages.send(sender, lines);
    }
}

