/*
 * Decompiled with CFR 0.152.
 */
package yt.jamesturner.navigation.commands.SubCommands;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import yt.jamesturner.navigation.commands.CommandFunctions;
import yt.jamesturner.navigation.data.type.SubCommand;

public class FindCommand
extends SubCommand {
    public FindCommand(CommandFunctions cf) {
        super(cf);
    }

    @Override
    public String getName() {
        return "find";
    }

    @Override
    public String getDescription() {
        return "Navigate to another player";
    }

    @Override
    public String getSyntax() {
        return "/poi find <Player Name>";
    }

    @Override
    public int getMaxNumberOfArgs() {
        return 2;
    }

    @Override
    public String getPermission() {
        return this.plugin.Config.getPermissionNode() + "commands.find";
    }

    @Override
    public String getPermissionDefault() {
        return "true";
    }

    @Override
    public boolean canPlayerRun() {
        return true;
    }

    @Override
    public boolean canConsoleRun() {
        return false;
    }

    @Override
    public void run(CommandSender sender, String[] args) {
        if (!this.cf.canRunCommand(this, sender)) {
            return;
        }
        if (args.length != 2) {
            this.cf.getCommandHelp(sender, this);
            return;
        }
        Player targetPlayer = this.plugin.getServer().getPlayer(args[1]);
        if (targetPlayer == null) {
            this.plugin.Messages.send(sender, "No player named {0} is online.", true, true, args[1]);
            return;
        }
        Player player = (Player)sender;
        if (!targetPlayer.getWorld().getName().equalsIgnoreCase(player.getWorld().getName())) {
            this.plugin.Messages.send(sender, "{0} is in another world. Travel to {1} first to begin navigation.", true, true, targetPlayer.getName(), targetPlayer.getLocation().getWorld().getName());
            return;
        }
        this.plugin.clearPlayerNavigation((Player)sender);
        this.plugin.addPlayerNavigation(player, targetPlayer);
    }

    @Override
    public List<String> getArguments(CommandSender sender, String[] args) {
        return null;
    }

    @Override
    public SubCommand getSubCommand(String name) {
        return null;
    }

    @Override
    public List<String> getSubCommands(CommandSender sender, String[] args) {
        if (args.length != 2) {
            return null;
        }
        if (sender instanceof Player) {
            ArrayList<String> players = new ArrayList<String>();
            for (Player p : this.plugin.getServer().getOnlinePlayers()) {
                if (p.getName().equalsIgnoreCase(((Player)sender).getName())) continue;
                players.add(p.getName());
            }
            return players;
        }
        return null;
    }
}

