/*
 * Decompiled with CFR 0.152.
 */
package yt.jamesturner.navigation.data;

import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import yt.jamesturner.navigation.Main;
import yt.jamesturner.navigation.data.type.LocationGroup;
import yt.jamesturner.navigation.data.type.SavedLocation;
import yt.jamesturner.navigation.utils.CustomConfig;

public class PlayerLocations
extends LocationGroup {
    Main plugin;
    private Player player;
    private CustomConfig savefile;

    public PlayerLocations(Main plugin, Player player) {
        this.plugin = plugin;
        this.player = player;
        this.savefile = new CustomConfig(plugin, player.getUniqueId().toString() + ".yml", "players");
        this.loadFile();
    }

    public boolean addSavedLocation(SavedLocation savedLocation, CommandSender sender) {
        if (!this.player.hasPermission(this.plugin.Config.getPermissionNode() + "location.unlimited") && this.savedLocations.size() >= this.plugin.Config.getPlayerLocationLimit()) {
            this.plugin.Messages.send(sender, this.plugin.Messages.highlight("You already have the maximum of {0} locations saved. Try removing one with {1}", String.valueOf(this.plugin.Config.getPlayerLocationLimit()), "/poi remove <Location Name>"), true, true);
            return false;
        }
        if (this.plugin.LocationsList.getGlobalLocations().contains(savedLocation.getCommandName()) != null) {
            this.plugin.Messages.send(sender, this.plugin.Messages.highlight("There is a global location named {0}, try a different name.", savedLocation.getDisplayName()), true, true);
            return false;
        }
        if (!this.contains(savedLocation)) {
            this.savedLocations.add(savedLocation);
            this.addSavedLocationByWorld(savedLocation);
            this.saveToFile();
            return true;
        }
        this.plugin.Messages.send(sender, this.plugin.Messages.highlight("You already have a location named {0}, try a different name.", savedLocation.getDisplayName()), true, true);
        return false;
    }

    public void removeSavedLocation(SavedLocation savedLocation) {
        this.savedLocations.remove(savedLocation);
    }

    public void removeSavedLocation(String commandName, CommandSender sender) {
        SavedLocation s = this.contains(commandName);
        if (s != null) {
            this.savedLocations.remove(s);
            this.savefile.getConfig().set("Locations." + s.getCommandNameLower(), null);
            this.savefile.save();
            this.plugin.Messages.send(sender, "You have removed {0}", true, false, s.getDisplayName());
            return;
        }
        this.plugin.Messages.send(sender, "You do not have a location named {0}", true, false, commandName);
    }

    public void saveToFile() {
        this.savefile.getConfig().set("Player.name", (Object)this.player.getName());
        this.savefile.getConfig().set("Player.uuid", (Object)this.player.getUniqueId().toString());
        for (SavedLocation s : this.savedLocations) {
            this.savefile.getConfig().set("Locations." + s.getCommandNameLower() + ".displayName", (Object)s.getDisplayName());
            this.savefile.getConfig().set("Locations." + s.getCommandNameLower() + ".commandName", (Object)s.getCommandName());
            this.savefile.getConfig().set("Locations." + s.getCommandNameLower() + ".location", (Object)s.getLocation());
        }
        this.savefile.save();
    }

    private void loadFile() {
        if (!this.savefile.getConfig().isConfigurationSection("Locations")) {
            return;
        }
        for (String key : this.savefile.getConfig().getConfigurationSection("Locations").getKeys(false)) {
            this.addSavedLocation(new SavedLocation(this.plugin, this.player, this.savefile.getConfig().getLocation("Locations." + key + ".location"), this.savefile.getConfig().getString("Locations." + key + ".displayName")), (CommandSender)Bukkit.getConsoleSender());
        }
    }
}

