/*
 * Decompiled with CFR 0.152.
 */
package yt.jamesturner.navigation.data.type;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import yt.jamesturner.navigation.data.type.SavedLocation;

public class LocationGroup {
    public ArrayList<SavedLocation> savedLocations = new ArrayList();
    private HashMap<String, ArrayList<SavedLocation>> savedLocationsByWorld = new HashMap();
    private int locationsPerPage = 8;

    public int size() {
        return this.savedLocations.size();
    }

    protected boolean contains(SavedLocation savedLocation) {
        return this.contains(savedLocation.getCommandName()) != null;
    }

    public SavedLocation contains(String commandName) {
        String commandNameLower = commandName.toLowerCase();
        for (SavedLocation s : this.savedLocations) {
            if (!s.getCommandNameLower().equals(commandNameLower)) continue;
            return s;
        }
        return null;
    }

    protected SavedLocation getSavedLocation(String commandName) {
        return this.contains(commandName);
    }

    public ArrayList<SavedLocation> getAllLocations(String world) {
        if (world.equalsIgnoreCase("*")) {
            return this.savedLocations;
        }
        return this.savedLocationsByWorld.get(world);
    }

    public List<SavedLocation> getPaginatedLocations(int page) {
        return this.getPaginatedLocations(page, "*");
    }

    public List<SavedLocation> getPaginatedLocations(int page, String world) {
        int num_of_pages = this.num_of_pages(world);
        page = this.verify_page(page, num_of_pages);
        int startIndex = (page - 1) * this.locationsPerPage;
        int toIndex = startIndex + this.locationsPerPage;
        if (world.equalsIgnoreCase("*")) {
            if (toIndex > this.savedLocations.size()) {
                toIndex = this.savedLocations.size();
            }
            return this.savedLocations.subList(startIndex, toIndex);
        }
        if (toIndex > this.getLocationsInWorld(world).size()) {
            toIndex = this.getLocationsInWorld(world).size();
        }
        return this.getLocationsInWorld(world).subList(startIndex, toIndex);
    }

    public TextComponent getPageButtons(int page, String world, boolean isPlayerList) {
        int num_of_pages = this.num_of_pages(world);
        page = this.verify_page(page, num_of_pages);
        if (num_of_pages == 1) {
            return null;
        }
        TextComponent message = new TextComponent();
        TextComponent page_num = new TextComponent("Page " + page);
        page_num.setColor(ChatColor.GOLD);
        page_num.setBold(Boolean.valueOf(true));
        TextComponent page_num_of = new TextComponent(" of " + num_of_pages);
        page_num_of.setColor(ChatColor.GOLD);
        TextComponent previous = new TextComponent();
        if (page > 1) {
            previous.addExtra((BaseComponent)new TextComponent("< Previous"));
            previous.setColor(ChatColor.GOLD);
            previous.setUnderlined(Boolean.valueOf(true));
            if (isPlayerList) {
                previous.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/poi mylist " + (page - 1)));
            } else {
                previous.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/poi list " + (page - 1)));
            }
            previous.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder((BaseComponent)new TextComponent("Click")).create()));
        } else {
            previous.addExtra((BaseComponent)new TextComponent("< Previous"));
            previous.setColor(ChatColor.GRAY);
            previous.setItalic(Boolean.valueOf(true));
        }
        TextComponent next = new TextComponent();
        if (page < num_of_pages) {
            next.addExtra((BaseComponent)new TextComponent("Next >"));
            next.setColor(ChatColor.GOLD);
            next.setUnderlined(Boolean.valueOf(true));
            if (isPlayerList) {
                next.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/poi mylist " + (page + 1)));
            } else {
                next.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/poi list " + (page + 1)));
            }
            next.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder((BaseComponent)new TextComponent("Click")).create()));
        } else {
            next.addExtra((BaseComponent)new TextComponent(""));
        }
        TextComponent spacer = new TextComponent("          ");
        message.addExtra((BaseComponent)previous);
        message.addExtra((BaseComponent)spacer);
        message.addExtra((BaseComponent)page_num);
        message.addExtra((BaseComponent)page_num_of);
        message.addExtra((BaseComponent)spacer);
        message.addExtra((BaseComponent)next);
        return message;
    }

    private int num_of_pages(String world) {
        if (world.equalsIgnoreCase("*")) {
            return this.getNumberOfPages();
        }
        return this.getNumberOfPages(world);
    }

    private int verify_page(int page, int num_of_pages) {
        if (page > num_of_pages) {
            return num_of_pages;
        }
        if (page < 1) {
            return 1;
        }
        return page;
    }

    public int getNumberOfPages() {
        return (int)Math.ceil(this.size() / this.locationsPerPage);
    }

    public int getNumberOfPages(String world) {
        return (int)Math.ceil((double)this.getLocationsInWorld(world).size() / (double)this.locationsPerPage);
    }

    public void addSavedLocationByWorld(SavedLocation s) {
        String world = s.getLocation().getWorld().getName();
        if (!this.savedLocationsByWorld.containsKey(world)) {
            this.savedLocationsByWorld.put(world, new ArrayList());
        }
        this.savedLocationsByWorld.get(world).add(s);
    }

    public ArrayList<SavedLocation> getLocationsInWorld(String world) {
        if (this.savedLocationsByWorld.get(world) == null) {
            return new ArrayList<SavedLocation>();
        }
        return this.savedLocationsByWorld.get(world);
    }
}

