/*
 * Decompiled with CFR 0.152.
 */
package yt.jamesturner.navigation.utils;

import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import yt.jamesturner.navigation.Main;

public class CustomConfig {
    Main plugin;
    private String fileName;
    private File directory;
    private File customConfigFile;
    private FileConfiguration customConfig = null;

    public CustomConfig(Main plugin, String fileName) {
        this.plugin = plugin;
        this.fileName = fileName;
        this.directory = plugin.getDataFolder();
        this.createConfig();
    }

    public CustomConfig(Main plugin, String fileName, String directory) {
        this.plugin = plugin;
        this.fileName = fileName;
        this.directory = new File(plugin.getDataFolder() + "/" + directory);
        this.createConfig();
    }

    public FileConfiguration getConfig() {
        if (this.customConfig != null) {
            return this.customConfig;
        }
        this.createConfig();
        return this.customConfig;
    }

    private void createConfig() {
        this.customConfigFile = new File(this.directory, this.fileName);
        if (!this.customConfigFile.exists()) {
            this.customConfigFile.getParentFile().mkdirs();
            if (this.plugin.getResource(this.fileName) != null) {
                this.plugin.saveResource(this.fileName, false);
            } else {
                try {
                    this.customConfigFile.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return;
                }
            }
        }
        this.customConfig = new YamlConfiguration();
        try {
            this.customConfig.load(this.customConfigFile);
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
    }

    public void save() {
        if (this.customConfigFile == null || this.customConfig == null) {
            this.createConfig();
            return;
        }
        try {
            this.customConfig.save(this.customConfigFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void load() {
        if (this.customConfigFile == null || this.customConfig == null) {
            this.createConfig();
            return;
        }
        try {
            this.customConfig.load(this.customConfigFile);
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
    }
}

