/*
 * Decompiled with CFR 0.152.
 */
package yt.jamesturner.navigation;

import java.text.Normalizer;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;
import yt.jamesturner.navigation.Listeners;
import yt.jamesturner.navigation.NavigationBar;
import yt.jamesturner.navigation.commands.Commands;
import yt.jamesturner.navigation.data.Config;
import yt.jamesturner.navigation.data.LocationsList;
import yt.jamesturner.navigation.data.type.SavedLocation;
import yt.jamesturner.navigation.utils.Messages;
import yt.jamesturner.navigation.utils.VersionCheck;

public class Main
extends JavaPlugin {
    public Messages Messages;
    public Config Config;
    public LocationsList LocationsList;
    private VersionCheck versionCheck;
    BukkitTask versionTask;
    private HashMap<UUID, NavigationBar> navigationBars = new HashMap();
    private int BarUpdateTaskID = -1;
    private static final String[] CARDINAL = new String[]{"North", "Northwest", "West", "Southwest", "South", "Southeast", "East", "Northeast"};
    private static final String[] CARDINAL_ABV = new String[]{"N", "NW", "W", "SW", "S", "SE", "E", "NE"};

    public void onEnable() {
        this.Messages = new Messages(this);
        this.Config = new Config(this);
        this.LocationsList = new LocationsList(this);
        this.getServer().getPluginManager().registerEvents((Listener)new Listeners(this), (Plugin)this);
        if (this.Config.canCheckVersion()) {
            this.versionCheck = new VersionCheck(this, (CommandSender)this.getServer().getConsoleSender(), true);
            this.getCommand("poi").setExecutor((CommandExecutor)new Commands(this));
            this.versionTask = this.versionCheck.runTaskLaterAsynchronously((Plugin)this, 20L);
        }
        this.updateBars();
    }

    public void onDisable() {
        for (UUID player : this.navigationBars.keySet()) {
            NavigationBar bar = this.navigationBars.get(player);
            bar.getBar().removeAll();
        }
        Bukkit.getScheduler().cancelTask(this.BarUpdateTaskID);
        if (this.versionTask != null) {
            Bukkit.getScheduler().cancelTask(this.versionTask.getTaskId());
        }
    }

    public boolean clearPlayerNavigation(Player player) {
        if (this.navigationBars.containsKey(player.getUniqueId())) {
            NavigationBar bar = this.navigationBars.get(player.getUniqueId());
            bar.getBar().removeAll();
            this.navigationBars.remove(player.getUniqueId());
            return true;
        }
        return false;
    }

    public void addPlayerNavigation(Player player, SavedLocation s) {
        NavigationBar bar = new NavigationBar(this, s.getDisplayName(), s.getLocation(), player);
        bar.createBar();
        bar.addPlayer(player);
        this.navigationBars.put(player.getUniqueId(), bar);
    }

    public void addPlayerNavigation(Player player, Player target) {
        NavigationBar bar = new NavigationBar(this, (Entity)target, player);
        bar.createBar();
        bar.addPlayer(player);
        this.navigationBars.put(player.getUniqueId(), bar);
    }

    public void updateBars() {
        this.setTaskID(Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, new Runnable(){

            @Override
            public void run() {
                for (Map.Entry entry : Main.this.navigationBars.entrySet()) {
                    ((NavigationBar)entry.getValue()).updateBar();
                }
            }
        }, 0L, (long)this.Config.getBarRefreshInterval()));
    }

    private void setTaskID(int taskID) {
        this.BarUpdateTaskID = taskID;
    }

    public String normalizeTextInput(String text) {
        return Normalizer.normalize(text, Normalizer.Form.NFD).replaceAll("[^A-Za-z0-9]", "");
    }

    public boolean isInteger(String input) {
        try {
            Integer.parseInt(input);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public String getDirection(Location source, Location destination, boolean abbreviate) {
        int compass = ((int)Math.round(Math.atan2(source.getX() - destination.getX(), source.getZ() - destination.getZ()) / 0.7853981633974483) + 8) % 8;
        if (abbreviate) {
            return CARDINAL_ABV[compass];
        }
        return CARDINAL[compass];
    }
}

