/*
 * Decompiled with CFR 0.152.
 */
package yt.jamesturner.navigation.commands.SubCommands;

import java.util.Arrays;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import yt.jamesturner.navigation.commands.CommandFunctions;
import yt.jamesturner.navigation.data.type.SavedLocation;
import yt.jamesturner.navigation.data.type.SubCommand;

public class AddCommand
extends SubCommand {
    public AddCommand(CommandFunctions cf) {
        super(cf);
    }

    @Override
    public String getName() {
        return "add";
    }

    @Override
    public String getDescription() {
        return "Add a location at your current position";
    }

    @Override
    public String getSyntax() {
        return "/poi add <Location Name>";
    }

    @Override
    public int getMaxNumberOfArgs() {
        return -1;
    }

    @Override
    public String getPermission() {
        return this.plugin.Config.getPermissionNode() + "commands.add";
    }

    @Override
    public String getPermissionDefault() {
        return "true";
    }

    @Override
    public boolean canPlayerRun() {
        return true;
    }

    @Override
    public boolean canConsoleRun() {
        return false;
    }

    @Override
    public void run(CommandSender sender, String[] args) {
        if (!this.cf.canRunCommand(this, sender)) {
            return;
        }
        Player player = (Player)sender;
        if (args.length > 1) {
            String displayName = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
            SavedLocation s = new SavedLocation(this.plugin, player, player.getLocation(), displayName);
            if (this.plugin.LocationsList.getPlayerLocations(player).addSavedLocation(s, sender)) {
                this.plugin.Messages.send(sender, this.plugin.Messages.highlight("{0} was saved at \u25ba ({1}, {2}, {3}) in {4}", s.getDisplayName(), String.valueOf(s.getLocation().getBlockX()), String.valueOf(s.getLocation().getBlockY()), String.valueOf(s.getLocation().getBlockZ()), s.getLocation().getWorld().getName()));
            }
        } else {
            this.cf.getCommandHelp(sender, this);
        }
    }

    @Override
    public List<String> getArguments(CommandSender sender, String[] args) {
        return null;
    }

    @Override
    public SubCommand getSubCommand(String name) {
        return null;
    }

    @Override
    public List<String> getSubCommands(CommandSender sender, String[] args) {
        return null;
    }
}

