/*
 * Decompiled with CFR 0.152.
 */
package yt.jamesturner.navigation.commands.SubCommands;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import yt.jamesturner.navigation.commands.CommandFunctions;
import yt.jamesturner.navigation.data.type.SavedLocation;
import yt.jamesturner.navigation.data.type.SubCommand;

public class CoordinatesCommand
extends SubCommand {
    public CoordinatesCommand(CommandFunctions cf) {
        super(cf);
    }

    @Override
    public String getName() {
        return "coordinates";
    }

    @Override
    public String getDescription() {
        return "Navigate to coordinates";
    }

    @Override
    public String getSyntax() {
        return "/poi coordinates <x> <y> <z>";
    }

    @Override
    public int getMaxNumberOfArgs() {
        return 4;
    }

    @Override
    public String getPermission() {
        return this.plugin.Config.getPermissionNode() + "commands.coordinates";
    }

    @Override
    public String getPermissionDefault() {
        return "true";
    }

    @Override
    public boolean canPlayerRun() {
        return true;
    }

    @Override
    public boolean canConsoleRun() {
        return false;
    }

    @Override
    public void run(CommandSender sender, String[] args) {
        if (!this.cf.canRunCommand(this, sender)) {
            return;
        }
        if (args.length < 4) {
            this.cf.getCommandHelp(sender, this);
            return;
        }
        Player player = (Player)sender;
        if (!(this.plugin.isInteger(args[1]) && this.plugin.isInteger(args[2]) && this.plugin.isInteger(args[3]))) {
            this.plugin.Messages.send(sender, "Ensure all coordinates are integers, eg {0}", true, true, "54 64 305");
            this.cf.getCommandHelp(sender, this);
            return;
        }
        this.plugin.clearPlayerNavigation(player);
        int x = Integer.valueOf(args[1]);
        int y = Integer.valueOf(args[2]);
        int z = Integer.valueOf(args[3]);
        this.plugin.addPlayerNavigation(player, new SavedLocation(this.plugin, player, new Location(player.getWorld(), (double)x, (double)y, (double)z), x + ", " + y + ", " + z));
    }

    @Override
    public List<String> getArguments(CommandSender sender, String[] args) {
        return null;
    }

    @Override
    public SubCommand getSubCommand(String name) {
        return null;
    }

    @Override
    public List<String> getSubCommands(CommandSender sender, String[] args) {
        ArrayList<String> locations = new ArrayList<String>();
        return locations;
    }
}

