/*
 * Decompiled with CFR 0.152.
 */
package yt.jamesturner.navigation.commands.SubCommands;

import java.util.ArrayList;
import java.util.List;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import yt.jamesturner.navigation.commands.CommandFunctions;
import yt.jamesturner.navigation.data.type.SavedLocation;
import yt.jamesturner.navigation.data.type.SubCommand;

public class ListCommand
extends SubCommand {
    public ListCommand(CommandFunctions cf) {
        super(cf);
    }

    @Override
    public String getName() {
        return "list";
    }

    @Override
    public String getDescription() {
        return "List global locations";
    }

    @Override
    public String getSyntax() {
        return "/poi list";
    }

    @Override
    public int getMaxNumberOfArgs() {
        return 2;
    }

    @Override
    public String getPermission() {
        return this.plugin.Config.getPermissionNode() + "commands.list";
    }

    @Override
    public String getPermissionDefault() {
        return "true";
    }

    @Override
    public boolean canPlayerRun() {
        return true;
    }

    @Override
    public boolean canConsoleRun() {
        return true;
    }

    @Override
    public void run(CommandSender sender, String[] args) {
        if (!this.cf.canRunCommand(this, sender)) {
            return;
        }
        if (this.plugin.LocationsList.getGlobalLocations().size() < 1) {
            this.plugin.Messages.send(sender, "There aren't any {0}.", true, false, "global locations");
            return;
        }
        ArrayList<TextComponent> locations = new ArrayList<TextComponent>();
        locations.add(new TextComponent("Global locations"));
        String world = "*";
        if (sender instanceof Player) {
            world = ((Player)sender).getLocation().getWorld().getName();
        }
        boolean alternateHighlight = false;
        if (sender instanceof Player) {
            int page = 1;
            if (args.length == 2 && this.plugin.isInteger(args[1])) {
                page = Integer.parseInt(args[1]);
            }
            for (SavedLocation s : this.plugin.LocationsList.getGlobalLocations().getPaginatedLocations(page, world)) {
                locations.add(this.plugin.LocationsList.listLocations(sender, s, alternateHighlight));
                if (alternateHighlight) {
                    alternateHighlight = false;
                    continue;
                }
                alternateHighlight = true;
            }
            TextComponent pageButtons = this.plugin.LocationsList.getGlobalLocations().getPageButtons(page, world, false);
            if (pageButtons != null) {
                locations.add(pageButtons);
            }
        } else {
            for (SavedLocation s : this.plugin.LocationsList.getGlobalLocations().getAllLocations(world)) {
                locations.add(this.plugin.LocationsList.listLocations(sender, s, alternateHighlight));
                if (alternateHighlight) {
                    alternateHighlight = false;
                    continue;
                }
                alternateHighlight = true;
            }
        }
        this.plugin.Messages.send(sender, locations, true, false, true);
    }

    @Override
    public List<String> getArguments(CommandSender sender, String[] args) {
        return null;
    }

    @Override
    public SubCommand getSubCommand(String name) {
        return null;
    }

    @Override
    public List<String> getSubCommands(CommandSender sender, String[] args) {
        ArrayList<String> pages = new ArrayList<String>();
        if (args.length != 2) {
            return pages;
        }
        if (sender instanceof Player) {
            for (int i = 1; i <= this.plugin.LocationsList.getGlobalLocations().getNumberOfPages(((Player)sender).getLocation().getWorld().getName()); ++i) {
                pages.add(String.valueOf(i));
            }
        } else {
            for (int i = 1; i <= this.plugin.LocationsList.getGlobalLocations().getNumberOfPages(); ++i) {
                pages.add(String.valueOf(i));
            }
        }
        return pages;
    }
}

