/*
 * Decompiled with CFR 0.152.
 */
package yt.jamesturner.navigation.data;

import yt.jamesturner.navigation.Main;

public class Config {
    Main plugin;
    private String permission_node = "navigation.";
    private int player_location_limit = 5;
    private int bar_refresh_interval = 10;
    private boolean find_other_players = true;
    private boolean version_check = true;

    public Config(Main plugin) {
        this.plugin = plugin;
        plugin.saveDefaultConfig();
        this.loadSettings();
    }

    private void loadSettings() {
        this.player_location_limit = this.loadConfigInt("PlayerLocationLimit", 5);
        this.bar_refresh_interval = this.loadConfigInt("RefreshInterval", 10);
        this.find_other_players = this.loadConfigBoolean("FindOtherPlayers", true);
        this.version_check = this.loadConfigBoolean("VersionCheck", true);
    }

    public String getPermissionNode() {
        return this.permission_node;
    }

    public int getPlayerLocationLimit() {
        return this.player_location_limit;
    }

    public int getBarRefreshInterval() {
        return this.bar_refresh_interval;
    }

    public boolean canCheckVersion() {
        return this.version_check;
    }

    public boolean canFindOtherPlayers() {
        return this.find_other_players;
    }

    private int loadConfigInt(String path, int fallback) {
        if (this.plugin.getConfig().isInt(path)) {
            return this.plugin.getConfig().getInt(path);
        }
        return fallback;
    }

    private boolean loadConfigBoolean(String path, boolean fallback) {
        if (this.plugin.getConfig().isBoolean(path)) {
            return this.plugin.getConfig().getBoolean(path);
        }
        return fallback;
    }
}

