/*
 * Decompiled with CFR 0.152.
 */
package yt.jamesturner.navigation;

import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import yt.jamesturner.navigation.Main;

public class NavigationBar {
    private Main plugin;
    private BossBar bar;
    private String name;
    private Player player;
    private Location to;
    private Entity target;
    private boolean movingTarget;
    private int initialDistance;
    private String initialDirection;
    public double progress = 1.0;
    public double last;
    public boolean decreasing = true;

    public NavigationBar(Main plugin, String name, Location to, Player player) {
        this.init(plugin, name, to, player, false, null);
    }

    public NavigationBar(Main plugin, Entity to, Player player) {
        this.init(plugin, to.getName(), to.getLocation(), player, true, to);
    }

    private void init(Main plugin, String name, Location to, Player player, boolean movingTarget, Entity entity) {
        this.plugin = plugin;
        this.name = name;
        this.player = player;
        this.to = to;
        this.last = player.getLocation().distance(to);
        this.movingTarget = movingTarget;
        this.target = entity;
        this.initialDistance = (int)Math.round(to.distance(player.getLocation()));
        this.initialDirection = plugin.getDirection(player.getLocation(), to, true);
    }

    public void addPlayer(Player player) {
        this.bar.addPlayer(player);
    }

    public BossBar getBar() {
        return this.bar;
    }

    public void updateBar() {
        if (this.movingTarget) {
            this.to = this.target.getLocation();
            if (this.target instanceof Player && !((Player)this.target).isOnline()) {
                this.plugin.Messages.send((CommandSender)this.player, "{0} has logged out. Navigation cancelled", true, false, this.target.getName());
                this.bar.setVisible(false);
                this.plugin.clearPlayerNavigation(this.player);
                return;
            }
            if (!this.to.getWorld().getName().equalsIgnoreCase(this.player.getLocation().getWorld().getName())) {
                this.plugin.Messages.send((CommandSender)this.player, "{0} has changed worlds. Go to {1} to find them.", true, false, this.target.getName(), this.target.getWorld().getName());
                this.bar.setVisible(false);
                this.plugin.clearPlayerNavigation(this.player);
                return;
            }
        }
        double distance = this.player.getLocation().distance(this.to);
        this.bar.setProgress(this.progress);
        this.progress = distance / (double)this.initialDistance;
        if (distance <= 5.0) {
            this.bar.setVisible(false);
            this.plugin.clearPlayerNavigation(this.player);
            return;
        }
        if (this.progress > 1.0) {
            this.progress = 1.0;
        }
        if (this.last < distance) {
            this.decreasing = false;
        }
        if (this.last > distance) {
            this.decreasing = true;
        }
        String direction = ChatColor.GOLD + this.plugin.getDirection(this.player.getLocation(), this.to, true) + ChatColor.RESET;
        if (!this.decreasing) {
            this.bar.setTitle(ChatColor.RED + "" + Math.round(distance) + ChatColor.RESET + " blocks " + direction + " from " + ChatColor.GOLD + this.name);
            this.bar.setColor(BarColor.RED);
        } else {
            this.bar.setTitle(ChatColor.GOLD + "" + Math.round(distance) + ChatColor.RESET + " blocks " + direction + " from " + ChatColor.GOLD + this.name);
            this.bar.setColor(BarColor.YELLOW);
        }
        this.last = distance;
    }

    public void createBar() {
        this.bar = Bukkit.createBossBar((String)(ChatColor.GOLD + "" + this.initialDistance + ChatColor.RESET + " blocks " + ChatColor.GOLD + this.initialDirection + ChatColor.RESET + " from " + ChatColor.GOLD + this.name), (BarColor)BarColor.YELLOW, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
        this.bar.setVisible(true);
    }
}

