/*
 * Decompiled with CFR 0.152.
 */
package yt.jamesturner.navigation.commands;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import yt.jamesturner.navigation.Main;
import yt.jamesturner.navigation.commands.CommandFunctions;
import yt.jamesturner.navigation.commands.SubCommands.AddCommand;
import yt.jamesturner.navigation.commands.SubCommands.CancelCommand;
import yt.jamesturner.navigation.commands.SubCommands.CoordinatesCommand;
import yt.jamesturner.navigation.commands.SubCommands.FindCommand;
import yt.jamesturner.navigation.commands.SubCommands.GlobalCommand;
import yt.jamesturner.navigation.commands.SubCommands.GotoCommand;
import yt.jamesturner.navigation.commands.SubCommands.ListCommand;
import yt.jamesturner.navigation.commands.SubCommands.MyListCommand;
import yt.jamesturner.navigation.commands.SubCommands.RemoveCommand;
import yt.jamesturner.navigation.data.type.SubCommand;

public class Commands
implements TabExecutor {
    Main plugin;
    private ArrayList<SubCommand> subCommands = new ArrayList();
    CommandFunctions cf;

    public Commands(Main plugin) {
        this.plugin = plugin;
        this.cf = new CommandFunctions(plugin);
        this.subCommands.add(new AddCommand(this.cf));
        this.subCommands.add(new RemoveCommand(this.cf));
        this.subCommands.add(new GlobalCommand(this.cf));
        this.subCommands.add(new ListCommand(this.cf));
        this.subCommands.add(new MyListCommand(this.cf));
        this.subCommands.add(new GotoCommand(this.cf));
        this.subCommands.add(new CancelCommand(this.cf));
        if (plugin.Config.canFindOtherPlayers()) {
            this.subCommands.add(new FindCommand(this.cf));
        }
        this.subCommands.add(new CoordinatesCommand(this.cf));
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length > 0) {
            for (SubCommand sc : this.subCommands) {
                if (!args[0].equalsIgnoreCase(sc.getName()) || sc.getMaxNumberOfArgs() != -1 && args.length > sc.getMaxNumberOfArgs()) continue;
                sc.run(sender, args);
                return true;
            }
        }
        this.cf.getCommandHelp(sender, this.subCommands);
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] args) {
        ArrayList<String> output = new ArrayList<String>();
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (args.length >= 1) {
                for (SubCommand sc : this.subCommands) {
                    List<String> subCommands;
                    if (!player.hasPermission(sc.getPermission()) || !sc.getName().startsWith(args[0].toLowerCase())) continue;
                    if (args.length == 1) {
                        output.add(sc.getName());
                        continue;
                    }
                    if (args.length == 2) {
                        subCommands = sc.getSubCommands(sender, args);
                        if (subCommands == null || subCommands.size() <= 0) continue;
                        for (String sc2 : subCommands) {
                            if (!sc2.toLowerCase().startsWith(args[1].toLowerCase())) continue;
                            output.add(sc2);
                        }
                        continue;
                    }
                    if (args.length != 3 || (subCommands = sc.getSubCommands(sender, args)) == null || subCommands.size() <= 0) continue;
                    for (String sc2 : subCommands) {
                        if (!sc2.toLowerCase().startsWith(args[2].toLowerCase())) continue;
                        output.add(sc2);
                    }
                }
                return output;
            }
        }
        return output;
    }
}

