/*
 * Decompiled with CFR 0.152.
 */
package yt.jamesturner.navigation.commands.SubCommands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import yt.jamesturner.navigation.commands.CommandFunctions;
import yt.jamesturner.navigation.data.type.SavedLocation;
import yt.jamesturner.navigation.data.type.SubCommand;

public class RemoveCommand
extends SubCommand {
    public RemoveCommand(CommandFunctions cf) {
        super(cf);
    }

    @Override
    public String getName() {
        return "remove";
    }

    @Override
    public String getDescription() {
        return "Remove a saved location";
    }

    @Override
    public String getSyntax() {
        return "/poi remove <Location Name>";
    }

    @Override
    public int getMaxNumberOfArgs() {
        return -1;
    }

    @Override
    public String getPermission() {
        return this.plugin.Config.getPermissionNode() + "commands.remove";
    }

    @Override
    public String getPermissionDefault() {
        return "true";
    }

    @Override
    public boolean canPlayerRun() {
        return true;
    }

    @Override
    public boolean canConsoleRun() {
        return false;
    }

    @Override
    public void run(CommandSender sender, String[] args) {
        if (!this.cf.canRunCommand(this, sender)) {
            return;
        }
        Player player = (Player)sender;
        if (args.length > 1) {
            String commandName = this.plugin.normalizeTextInput(String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length)));
            this.plugin.LocationsList.getPlayerLocations(player).removeSavedLocation(commandName, sender);
        } else {
            this.cf.getCommandHelp(sender, this);
        }
    }

    @Override
    public List<String> getArguments(CommandSender sender, String[] args) {
        return null;
    }

    @Override
    public SubCommand getSubCommand(String name) {
        return null;
    }

    @Override
    public List<String> getSubCommands(CommandSender sender, String[] args) {
        ArrayList<String> locations = new ArrayList<String>();
        if (args.length != 2) {
            return locations;
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            for (SavedLocation s : this.plugin.LocationsList.getPlayerLocations(player).getAllLocations("*")) {
                locations.add(s.getDisplayName());
            }
        }
        return locations;
    }
}

