/*
 * Decompiled with CFR 0.152.
 */
package yt.jamesturner.navigation.data;

import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import yt.jamesturner.navigation.Main;
import yt.jamesturner.navigation.data.type.LocationGroup;
import yt.jamesturner.navigation.data.type.SavedLocation;
import yt.jamesturner.navigation.utils.CustomConfig;

public class GlobalLocations
extends LocationGroup {
    Main plugin;
    private CustomConfig savefile;

    public GlobalLocations(Main plugin) {
        this.plugin = plugin;
        this.savefile = new CustomConfig(plugin, "GlobalLocations.yml");
        this.loadFile();
    }

    public boolean addSavedLocation(SavedLocation savedLocation, CommandSender sender) {
        if (!sender.hasPermission(this.plugin.Config.getPermissionNode() + "commands.global")) {
            this.plugin.Messages.send(sender, "You do not have permission to add or remove global points of interest", true, true);
            return false;
        }
        if (!this.contains(savedLocation)) {
            this.savedLocations.add(savedLocation);
            this.addSavedLocationByWorld(savedLocation);
            this.saveToFile();
            return true;
        }
        this.plugin.Messages.send(sender, this.plugin.Messages.highlight("There is already a location named {0}, try a different name.", savedLocation.getDisplayName()), true, true);
        return false;
    }

    public void removeSavedLocation(SavedLocation savedLocation) {
        this.savedLocations.remove(savedLocation);
    }

    public void removeSavedLocation(String commandName, CommandSender sender) {
        SavedLocation s = this.contains(commandName);
        if (s != null) {
            this.savedLocations.remove(s);
            this.savefile.getConfig().set("Locations." + s.getCommandNameLower(), null);
            this.savefile.save();
            this.plugin.Messages.send(sender, "You have removed {0}", true, false, s.getDisplayName());
            return;
        }
        this.plugin.Messages.send(sender, "There is no location named {0}", true, false, commandName);
    }

    public void saveToFile() {
        for (SavedLocation s : this.savedLocations) {
            this.savefile.getConfig().set("Locations." + s.getCommandNameLower() + ".displayName", (Object)s.getDisplayName());
            this.savefile.getConfig().set("Locations." + s.getCommandNameLower() + ".commandName", (Object)s.getCommandName());
            this.savefile.getConfig().set("Locations." + s.getCommandNameLower() + ".location", (Object)s.getLocation());
        }
        this.savefile.save();
    }

    private void loadFile() {
        if (this.savefile.getConfig().isConfigurationSection("Locations")) {
            for (String key : this.savefile.getConfig().getConfigurationSection("Locations").getKeys(false)) {
                this.addSavedLocation(new SavedLocation(this.plugin, this.savefile.getConfig().getLocation("Locations." + key + ".location"), this.savefile.getConfig().getString("Locations." + key + ".displayName")), (CommandSender)Bukkit.getConsoleSender());
            }
        }
    }
}

