/*
 * Decompiled with CFR 0.152.
 */
package yt.jamesturner.navigation.data;

import java.util.HashMap;
import java.util.UUID;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import yt.jamesturner.navigation.Main;
import yt.jamesturner.navigation.data.GlobalLocations;
import yt.jamesturner.navigation.data.PlayerLocations;
import yt.jamesturner.navigation.data.type.SavedLocation;

public class LocationsList {
    Main plugin;
    GlobalLocations GlobalLocations;
    HashMap<UUID, PlayerLocations> PlayerLocations = new HashMap();

    public LocationsList(Main plugin) {
        this.plugin = plugin;
        this.GlobalLocations = new GlobalLocations(plugin);
    }

    public PlayerLocations getPlayerLocations(Player player) {
        if (this.PlayerLocations.containsKey(player.getUniqueId())) {
            return this.PlayerLocations.get(player.getUniqueId());
        }
        return this.addPlayer(player);
    }

    public void unloadPlayerLocations(Player player) {
        this.PlayerLocations.remove(player.getUniqueId());
    }

    private PlayerLocations addPlayer(Player player) {
        this.PlayerLocations.put(player.getUniqueId(), new PlayerLocations(this.plugin, player));
        return this.PlayerLocations.get(player.getUniqueId());
    }

    public GlobalLocations getGlobalLocations() {
        return this.GlobalLocations;
    }

    public TextComponent listLocations(CommandSender sender, SavedLocation s, boolean invertColors) {
        ChatColor highlight = ChatColor.WHITE;
        ChatColor defaultColor = ChatColor.GRAY;
        if (invertColors) {
            highlight = ChatColor.of((String)"#cacaca");
        }
        TextComponent isAt = new TextComponent("is at ");
        isAt.setColor(defaultColor);
        TextComponent arrow = new TextComponent("\u25ba ");
        arrow.setColor(defaultColor);
        TextComponent comma = new TextComponent(", ");
        comma.setColor(defaultColor);
        TextComponent leftParenthesis = new TextComponent("(");
        leftParenthesis.setColor(defaultColor);
        TextComponent rightParenthesis = new TextComponent(")");
        rightParenthesis.setColor(defaultColor);
        TextComponent in = new TextComponent(" in ");
        in.setColor(defaultColor);
        TextComponent message = new TextComponent();
        TextComponent displayName = new TextComponent(s.getDisplayName());
        displayName.setColor(highlight);
        TextComponent x = new TextComponent(String.valueOf(s.getLocation().getBlockX()));
        x.setColor(highlight);
        TextComponent y = new TextComponent(String.valueOf(s.getLocation().getBlockY()));
        y.setColor(highlight);
        TextComponent z = new TextComponent(String.valueOf(s.getLocation().getBlockZ()));
        z.setColor(highlight);
        TextComponent coordinates = new TextComponent();
        coordinates.addExtra((BaseComponent)leftParenthesis);
        coordinates.addExtra((BaseComponent)x);
        coordinates.addExtra((BaseComponent)comma);
        coordinates.addExtra((BaseComponent)y);
        coordinates.addExtra((BaseComponent)comma);
        coordinates.addExtra((BaseComponent)z);
        coordinates.addExtra((BaseComponent)rightParenthesis);
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (s.getLocation().getWorld().getName().equalsIgnoreCase(player.getLocation().getWorld().getName())) {
                TextComponent hoverMessage = this.locationHoverMessage(player, displayName, s.getLocation());
                coordinates.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/poi goto " + s.getCommandName()));
                coordinates.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder((BaseComponent)hoverMessage).create()));
            } else {
                coordinates.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder((BaseComponent)displayName).append((BaseComponent)new TextComponent(" is in another world")).create()));
            }
            displayName.setColor(highlight);
            message.addExtra((BaseComponent)displayName);
            message.addExtra((BaseComponent)new TextComponent(" "));
            message.addExtra((BaseComponent)isAt);
            message.addExtra((BaseComponent)arrow);
            message.addExtra((BaseComponent)coordinates);
            return message;
        }
        TextComponent world = new TextComponent(s.getLocation().getWorld().getName());
        world.setColor(highlight);
        message.addExtra((BaseComponent)displayName);
        message.addExtra((BaseComponent)new TextComponent(" "));
        message.addExtra((BaseComponent)isAt);
        message.addExtra((BaseComponent)coordinates);
        message.addExtra((BaseComponent)in);
        message.addExtra((BaseComponent)world);
        return message;
    }

    public TextComponent locationHoverMessage(Player player, TextComponent displayName, Location destination) {
        ChatColor defaultColor = ChatColor.GRAY;
        TextComponent hoverMessage = new TextComponent();
        TextComponent gotoMessage = new TextComponent("Go to ");
        gotoMessage.setColor(ChatColor.GRAY);
        TextComponent hoverName = displayName;
        hoverName.setColor(this.plugin.Messages.chatPrefixColor_bungee);
        TextComponent distance = new TextComponent(String.valueOf(Math.round(player.getLocation().distance(destination))) + " ");
        distance.setColor(ChatColor.WHITE);
        TextComponent direction = new TextComponent("blocks to your ");
        direction.setColor(ChatColor.GRAY);
        TextComponent cardinal = new TextComponent(this.plugin.getDirection(player.getLocation(), destination, false));
        cardinal.setColor(ChatColor.WHITE);
        hoverMessage.addExtra((BaseComponent)gotoMessage);
        hoverMessage.addExtra((BaseComponent)hoverName);
        TextComponent comma = new TextComponent(", ");
        comma.setColor(defaultColor);
        hoverMessage.addExtra((BaseComponent)comma);
        hoverMessage.addExtra((BaseComponent)distance);
        hoverMessage.addExtra((BaseComponent)direction);
        hoverMessage.addExtra((BaseComponent)cardinal);
        return hoverMessage;
    }
}

