/*
 * Decompiled with CFR 0.152.
 */
package yt.jamesturner.DeathChest;

import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import yt.jamesturner.DeathChest.ChestData;
import yt.jamesturner.DeathChest.Chests;
import yt.jamesturner.DeathChest.ConfigFiles.Config;
import yt.jamesturner.DeathChest.Main;

public class Listeners
implements Listener {
    Main Plugin;
    Config Config;
    Chests Chests;

    public Listeners(Main plugin) {
        this.Plugin = plugin;
        this.Config = plugin.Config;
        this.Chests = plugin.Chests;
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent e) {
        Player player = e.getEntity();
        if (this.Config.settings.containsKey("ChestInLava") && !((Boolean)this.Config.settings.get("ChestInLava")).booleanValue() && player.getLastDamageCause().getCause().equals((Object)EntityDamageEvent.DamageCause.LAVA)) {
            return;
        }
        if (this.Chests.inventoryIsEmpty(player.getInventory().getContents())) {
            return;
        }
        ChestData chest = this.Chests.createNewChest(player, e.getDrops());
        this.Plugin.DeathChests.put(chest.getConfigKey(), chest);
        this.Config.saveChestToConfig(chest);
        this.Config.ChestsYML.save();
        this.Config.ChestsYML.load();
        e.getDrops().clear();
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent e) {
        if (e.getClickedBlock() == null) {
            return;
        }
        if (this.Chests.openChest(e.getPlayer(), e.getClickedBlock()).booleanValue()) {
            e.setCancelled(true);
            return;
        }
        if (this.checkBlockBehindSign(e.getPlayer(), e.getClickedBlock())) {
            e.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void entityExplodeEvent(EntityExplodeEvent e) {
        Block[] blockArray = e.blockList().toArray(new Block[e.blockList().size()]);
        int n = blockArray.length;
        int n2 = 0;
        while (n2 < n) {
            Block b = blockArray[n2];
            if (this.Plugin.DeathChests.containsKey(this.Chests.locationToConfig(b.getLocation()))) {
                ChestData chest = this.Plugin.DeathChests.get(this.Chests.locationToConfig(b.getLocation()));
                e.blockList().remove(b);
                if (chest.hasSign() && e.blockList().contains(chest.getSignLocation().getBlock())) {
                    e.blockList().remove(chest.getSignLocation().getBlock());
                }
            }
            ++n2;
        }
    }

    @EventHandler
    public void blockDamageEvent(BlockDamageEvent e) {
        if (this.checkBlockBehindSign(e.getPlayer(), e.getBlock())) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void blockBreakEvent(BlockBreakEvent e) {
        if (this.checkBlockBehindSign(e.getPlayer(), e.getBlock())) {
            e.setCancelled(true);
        }
    }

    private boolean checkBlockBehindSign(Player player, Block block) {
        Block b = this.Chests.isSignAttachedToDeathChest(block);
        if (b != null) {
            this.Chests.openChest(player, b);
            return true;
        }
        return false;
    }

    @EventHandler
    public void onPlayerRespawn(PlayerRespawnEvent e) {
    }

    @EventHandler
    public void onGUIClose(InventoryCloseEvent e) {
        if (!e.getView().getTitle().startsWith("Contents: ")) {
            return;
        }
        String coordinates = e.getView().getTitle().substring(10);
        if (!this.Plugin.DeathChests.containsKey(coordinates = coordinates.replaceAll("\\s+", ""))) {
            return;
        }
        ChestData chest = this.Plugin.DeathChests.get(coordinates);
        chest.setInventory(e.getInventory().getContents());
        this.Plugin.DeathChests.put(coordinates, chest);
        if (chest.isEmpty()) {
            this.Config.removeChest(chest);
        }
        if (this.Plugin.OpenedChests.containsKey(chest.getInventoryName())) {
            this.Plugin.OpenedChests.remove(chest.getInventoryName());
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent e) {
        if (this.Config.settings.containsKey("VersionCheck") && ((Boolean)this.Config.settings.get("VersionCheck")).booleanValue() && e.getPlayer().hasPermission("deathchest.commands") && this.Plugin.newUpdate.length() > 0) {
            this.Plugin.sendChatMessage(e.getPlayer(), this.Plugin.newUpdate);
        }
    }
}

