/*
 * Decompiled with CFR 0.152.
 */
package yt.jamesturner.DeathChest;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import yt.jamesturner.DeathChest.Main;

public class VersionCheck
extends BukkitRunnable {
    Main plugin;
    String version;
    boolean startup;
    CommandSender sender;
    String url = "https://jamesturner.yt/post/deathchest";

    public VersionCheck(Main plugin, CommandSender sender, boolean startup) {
        this.plugin = plugin;
        this.startup = startup;
        this.sender = sender;
        this.version = plugin.getDescription().getVersion();
    }

    public void run() {
        String result = this.checkVersion();
        if (result.equals("")) {
            return;
        }
        List<String> lines = this.resultLinesToList(result);
        if (this.sender instanceof Player) {
            this.plugin.sendChatMessage((Player)this.sender, lines);
            return;
        }
        this.plugin.sendConsoleMessage(lines);
    }

    private String checkVersion() {
        JSONObject json;
        ArrayList<String> error_messages;
        block12: {
            error_messages = new ArrayList<String>();
            error_messages.add(ChatColor.RED + "API Request Error");
            URLConnection connection = new URL(String.valueOf(this.url) + "/api").openConnection();
            connection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/28.0.1500.29 Safari/537.36");
            Scanner scanner = new Scanner(connection.getInputStream());
            String data = scanner.nextLine();
            scanner.close();
            JSONParser jsonParser = new JSONParser();
            json = (JSONObject)jsonParser.parse(data);
            if (!json.containsKey((Object)"error")) break block12;
            JSONArray error = (JSONArray)json.get((Object)"error");
            if (error != null) {
                for (Object message : error) {
                    error_messages.add(" - " + ChatColor.DARK_GRAY + message.toString());
                }
            } else {
                error_messages.add(" - " + ChatColor.DARK_GRAY + "No error messages found");
            }
            this.plugin.sendConsoleMessage(error_messages, ChatColor.RESET);
            return "";
        }
        try {
            String latest_version = (String)json.get((Object)"version");
            String version_info = "";
            switch (VersionCheck.compare(latest_version, this.version)) {
                case -1: {
                    version_info = "You are running" + ChatColor.GREEN + " PREVIEW-" + this.version;
                    break;
                }
                case 0: {
                    if (this.startup) break;
                    version_info = "You are running the latest version";
                    break;
                }
                case 1: {
                    String playerMessage = ChatColor.GREEN + "New update available " + ChatColor.RESET + "- Check details at:;" + ChatColor.UNDERLINE + this.url;
                    version_info = this.sender instanceof Player ? playerMessage : ChatColor.GREEN + "NEW UPDATE AVAILABLE;" + ChatColor.DARK_GRAY + "Check changelog and details at:;" + ChatColor.RESET + this.url;
                    this.plugin.newUpdate = "New update available - " + ChatColor.UNDERLINE + this.url;
                    break;
                }
                default: {
                    version_info = "Couldn't get version info";
                }
            }
            return version_info;
        }
        catch (IOException e) {
            e.printStackTrace();
            error_messages.add(" - " + ChatColor.DARK_GRAY + "Couldn't fetch latest plugin version");
            this.plugin.sendConsoleMessage(error_messages, ChatColor.RESET);
            return "";
        }
        catch (ParseException e) {
            e.printStackTrace();
            error_messages.add(" - " + ChatColor.DARK_GRAY + "Couldn't parse JSON");
            this.plugin.sendConsoleMessage(error_messages, ChatColor.RESET);
            return "";
        }
    }

    private List<String> resultLinesToList(String result) {
        String[] result_lines = result.split(";");
        return Arrays.asList(result_lines);
    }

    public static int compare(String left, String right) {
        int result;
        if (left.equals(right)) {
            return 0;
        }
        int leftStart = 0;
        int rightStart = 0;
        do {
            int leftEnd = left.indexOf(46, leftStart);
            int rightEnd = right.indexOf(46, rightStart);
            Integer leftValue = Integer.parseInt(leftEnd < 0 ? left.substring(leftStart) : left.substring(leftStart, leftEnd));
            Integer rightValue = Integer.parseInt(rightEnd < 0 ? right.substring(rightStart) : right.substring(rightStart, rightEnd));
            result = leftValue.compareTo(rightValue);
            leftStart = leftEnd + 1;
            rightStart = rightEnd + 1;
        } while (result == 0 && leftStart > 0 && rightStart > 0);
        if (result == 0) {
            if (leftStart > rightStart) {
                return VersionCheck.containsNonZeroValue(left, leftStart) ? 1 : 0;
            }
            if (leftStart < rightStart) {
                return VersionCheck.containsNonZeroValue(right, rightStart) ? -1 : 0;
            }
        }
        return result;
    }

    private static boolean containsNonZeroValue(String str, int beginIndex) {
        int i = beginIndex;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c != '0' && c != '.') {
                return true;
            }
            ++i;
        }
        return false;
    }
}

